#!/bin/bash

## Auto generate Snowball cheatsheet for user
## Created by: Boon Shin Ng

## Version 1.0 (Sep 7, 2019)
## Version 1.1 (Dec 4, 2019)

## CHCLI template: Snowball_Cheatsheet_Template_1.48.txt

## VARIABLES
template="./system_files/Snowball_Cheatsheet_Template_1.49.txt"
chcli_ver="1.49"


clear

echo ' __    _  _______  _______  _______  ___      ___   __   __ '
echo '|  |  | ||       ||       ||       ||   |    |   | |  |_|  |'
echo '|   |_| ||    ___||_     _||    ___||   |    |   | |       |'
echo '|       ||   |___   |   |  |   |___ |   |    |   | |       |'
echo '|  _    ||    ___|  |   |  |    ___||   |___ |   |  |     | '
echo '| | |   ||   |___   |   |  |   |    |       ||   | |   _   |'
echo '|_|  |__||_______|  |___|  |___|    |_______||___| |__| |__|'
echo


echo '************************************************************'
echo '**                                                        **'
echo '**     A series of steps to generate your own             **'
echo '**     Snowball cheatsheet of commands.                   **'
echo '**                                                        **'
echo '**     Search for "snowball cheatsheet" in                **'
echo '**     Netflix Partner Help Center                        **'
echo '**     https://partnerhelp.netflixstudios.com             **'
echo '**     for more details.                                  **'
echo '**                                                        **'
echo '**     A text file will be generated at the end           **'
echo '**     of this process.                                   **'
echo '**                                                        **'
echo '************************************************************'
echo


echo '**********************************************************************'
echo '**                                                                  **'
echo '**     Step 1 of 5: Generate API key.                               **'
echo '**                                                                  **'
echo '**     Please generate the vendor API key in Starship.              **'
echo '**     https://starship.netflixstudios.com/                         **'
echo '**                                                                  **'
echo '**********************************************************************'
echo

until [ ! -z "$client_id" ]
do
   echo '-> Paste Client ID below and hit <return>.' && read client_id
done

until [ ! -z "$client_secret" ]
do
   echo '-> Paste Client Secret below and hit <return>.' && read client_secret
done


clear
echo '**********************************************************************'
echo '**                                                                  **'
echo '**     Step 2 of 5: Snowball job name.                              **'
echo '**                                                                  **'
echo '**     The Snowball job name can be found in your email.            **'
echo '**     It starts with NFLX- and ends with a series of digits.       **'
echo '**                                                                  **'
echo '**********************************************************************'
echo

until [ ! -z "$jobname" ]
do
   echo '-> Enter Snowball jobname below and hit <return>.' && read jobname
done

clear
echo '**********************************************************************'
echo '**                                                                  **'
echo '**     Step 3 of 5: Snowball IP.                                    **'
echo '**                                                                  **'
echo '**     Provide the Snowball IP address that is found in the         **'
echo '**     front LCD panel of the Snowball Edge device.                 **'
echo '**                                                                  **'
echo '**********************************************************************'
echo

until [ ! -z "$snowball_ip" ]
do
   echo '-> Enter Snowball IP below and hit <return>.' && read snowball_ip
done

clear
echo '**********************************************************************'
echo '**                                                                  **'
echo '**     Step 4 of 5: Email address.                                  **'
echo '**                                                                  **'
echo '**     Please provide email address used for Snowball.              **'
echo '**                                                                  **'
echo '**********************************************************************'
echo

until [ ! -z "$email" ]
do
   echo '-> Enter your email address below and hit <return>.' && read email
done


clear
echo '**********************************************************************'
echo '**                                                                  **'
echo '**     Step 5 of 5: Email password.                                 **'
echo '**                                                                  **'
echo '**     Note that this will be stored in plain text.                 **'
echo '**                                                                  **'
echo '**********************************************************************'
echo

echo '-> Enter email password.' && read email_password

###########
##
## Create cheatsheet.txt file
##
###########

## Output Filename – <Snowball Jobname>_Snowball_Cheatsheet_<chcli_ver>.txt
output_filename=Snowball_cheatsheet_$chcli_ver"_"$jobname.txt

sed "
s/<CLIENT_ID>/$client_id/g
s/<CLIENT_SECRET>/$client_secret/g
s/<JOBNAME>/$jobname/g
s/<SNOWBALL_IP>/$snowball_ip/g
s/<EMAIL>/$email/g
s/<EMAIL_PASSWORD>/$email_password/g
" ./$template > $output_filename

clear
echo '**********************************************************************'
echo '**                                                                  **'
echo '**     Cheatsheet has been created in the same folder where         **'
echo '**     this command is run.                                         **'
echo '**                                                                  **'
echo '**********************************************************************'
echo
echo 'Filename: '$output_filename''
echo

open ./$output_filename
